/**
 * De klasse Ridder beschrijft het gedrag van een ridder in een computergame
 * 
 * @author Dominiek Vandewalle
 * @version 2015-06-30
 */
public class Ridder
{
    //velden
    private String naam;
    private double gezondheid;
    private Harnas harnas;
    
    /**
     * Constructor voor objecten van de klasse Ridder.
     * Ridders worden geboren met 100% gezondheid en slechts één leven
     * @param   naam    De naam van ridder
     */
    public Ridder(String naam)
    {
        this.naam = naam;
        gezondheid = 100;
    }
    
    /**
     * Geeft de naam van de ridder terug.
     * @return     De naam van de ridder. 
     */
    public String getNaam()
    {
        return naam;
    }
    
    /**
     * Geeft het aantal levens van de ridder terug.
     * @return     Het aantal levens van de ridder
     */
    public double getGezondheid()
    {
        return gezondheid;
    }
    
    /**
     * Geeft het harnas van de ridder terug.
     * @return     Het harnas van de ridder.
     */
    public Harnas getHarnas()
    {
        return harnas;
    }
    
    /**
     * Geeft aan of de ridder al dan niet dood is.
     * @return     True indien de ridder dood is, anders false.
     */
    public boolean isDood()
    {
        return gezondheid == 0;
    }
    
    /**
     * Een andere ridder aanvallen. 
     * @param   Ridder  De tegenstander die wordt aangevallen door dit object.
     */
    public void aanvallen(Ridder tegenstander)
    {
        tegenstander.geraakt();
    }
    
    /**
     * Indien de ridder geraakt wordt dan verliest de ridder 1 leven.
     */
    public void geraakt()
    {
        if(harnas != null)
        {
            gezondheid -= (1 - harnas.getBeschermingsfactor()) * 100;
            gezondheid = Math.max(gezondheid,0);
        }
        else
        {
            gezondheid = 0;
        }
    }
    
    /**
     * Ridderobject trekt een bestaand harnas aan.
     * @param   harnas  Het harnas dat de ridder aantrekt.
     */
    public void setHarnas(Harnas harnas)
    {
        this.harnas = harnas;
    }
    
    /**
     * Ridderobject trekt een nieuw te maken harnas aan.
     * @param   type    Het type van het harnas.
     * @param   beschermingsfactor  De beschermingsfactor van het harnas.
     */
    public void nieuwHarnasAantrekken(String type, double beschermingsfactor)
    {
        harnas = new Harnas(type, beschermingsfactor);
    }
    
    /**
     * Ridderobject trekt het harnas uit.
     */
    public void harnasUittrekken()
    {
        harnas = null;
    }
    
    /**
     * Info over ridderobject naar terminalvenster printen.
     */
    public void info()
    {
        System.out.println("Naam: " + naam + "\nGezondheid: " + gezondheid);
        if(harnas != null)
        {
            System.out.println(harnas.toString());
        }
    }
}